
rem
bbdoc: encapsulates logic to do bilinear interpolation
.V1		.V4
.V2		.V3
end rem
Type TCircularInterpolator

	Field circleValue1:Float
	Field circleValue2:Float
	
	Field value1:Float
	Field value2:Float
	Field value3:Float
	Field value4:Float
	
	Field maxValue:Float = MathHelper.MaxValueF
	Field minvalue:Float = MathHelper.MinValueF
	Field twoOverPi:Float = 1 / MathHelper.PiOver2
	
	Function Create:TCircularInterpolator(value1:Float, value2:Float, value3:Float, value4:Float, minValue:Float, maxValue:Float)
		Local interp:TCircularInterpolator = New TCircularInterpolator
		interp.value1 = value1
		interp.value2 = value2
		interp.value3 = value3
		interp.value4 = value4
		interp.minvalue = minValue
		interp.maxValue = maxValue
		Return interp
	End Function
	
	Method GetValueFromVector:Float(position:Vector2)
		Return GetValue(position.X, position.Y)
	End Method
	
	Method GetValue:Float(x:Float, y:Float)
		Local theta:Float
		Local lerpValue:Float
		Local d:Float
		Local value:Float = 0
		
		d = MathHelper.Distance(x, y)
		
		' quadrant 1
		If (x > 0 And y > 0) Then
			theta = ATan2(y, x)
			lerpValue = theta * twoOverPi
			circleValue1 = MathHelper.Lerp(value1, value2, lerpValue)
			circleValue2 = MathHelper.Lerp(value3, value4, lerpValue)
			value = MathHelper.Lerp(circleValue1, circleValue2, (1 - d) *.5)
		End If
		If x < 0 And y > 0 Then
			theta = ATan2(y, x)
			lerpValue = (theta - MathHelper.PiOver2) * twoOverPi
			circleValue1 = MathHelper.Lerp(value2, value3, lerpValue)
			circleValue2 = MathHelper.Lerp(value4, value1, lerpValue)
			value = MathHelper.Lerp(circleValue1, circleValue2, (1 - d) *.5)
		End If
		If x < 0 And y < 0 Then
			theta = ATan2(y, x) + MathHelper.TwoPi
			lerpValue = (theta - MathHelper.Pi) * twoOverPi
			circleValue1 = MathHelper.Lerp(value3, value4, lerpValue)
			circleValue2 = MathHelper.Lerp(value1, value2, lerpValue)
			value = MathHelper.Lerp(circleValue1, circleValue2, (1 - d) *.5)
		End If
		
		If x > 0 And y < 0 Then
			theta = ATan2(y, x) + MathHelper.TwoPi
			lerpValue = (theta - 3 * MathHelper.PiOver2) * twoOverPi
			circleValue1 = MathHelper.Lerp(value4, value1, lerpValue)
			circleValue2 = MathHelper.Lerp(value2, value3, lerpValue)
			value = MathHelper.Lerp(circleValue1, circleValue2, (1 - d) *.5)
		End If
		
		If x = 0 And y > 0 Then
			value = MathHelper.Lerp(value2, value4, (1 - y) / 2.0)			
		End If
		
		If x = 0 And y < 0 Then
			value = MathHelper.Lerp(value4, value2, (1 + y) / 2.0) ' 1--y			
		End If
		
		If x > 0 And y = 0 Then
			value = MathHelper.Lerp(value1, value3, (1 - x) / 2.0)
		End If
		
		If x < 0 And y = 0 Then
			value = MathHelper.Lerp(value3, value1, (1 + x) / 2.0) ' 1 --y
		End If
		
		Return MathHelper.Clamp(value, minValue, maxValue)
	End Method
End Type
